<?php
require 'admin/db_config.php';

// URL থেকে ID নেওয়া
if(isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM team WHERE id = $id";
    $result = $conn->query($sql);
    
    if($result->num_rows > 0) {
        $row = $result->fetch_assoc();
    } else {
        die("মেম্বার পাওয়া যায়নি!");
    }
} else {
    header("Location: index.php");
    exit;
}

// কাজের সময়কাল বের করার লজিক
$join_date = new DateTime($row['joining_date']);
$today = new DateTime();
$interval = $join_date->diff($today);
$duration = "";

if($interval->y > 0) { $duration .= $interval->y . " বছর "; }
if($interval->m > 0) { $duration .= $interval->m . " মাস"; }
if($interval->y == 0 && $interval->m == 0) { $duration = "১ মাসের কম"; }
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/jpeg" href="https://cdn3d.iconscout.com/3d/premium/thumb/html-3d-icon-png-download-12760849.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($row['name']); ?> - প্রোফাইল | CodexioBD</title>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --bg-color: #f0f0f3;
            --shadow-dark: #aeaec0;
            --shadow-light: #ffffff;
            --text-main: #4a4d6d;
            --accent-pink: #ff4d8d;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        
        body { 
            background-color: var(--bg-color); 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            min-height: 100vh; 
            padding: 20px 10px; 
            color: var(--text-main);
        }

        /* মেইন কন্টেইনার (Raised effect) */
        .main-container {
            width: 100%;
            max-width: 900px;
            background: var(--bg-color);
            border-radius: 50px;
            padding: 50px;
            box-shadow: 20px 20px 60px var(--shadow-dark), -20px -20px 60px var(--shadow-light);
            border: 1px solid rgba(255, 255, 255, 0.2);
            position: relative;
        }

        /* ব্যাক বাটন */
        .btn-back {
            display: inline-block;
            margin-bottom: 30px;
            text-decoration: none;
            color: var(--text-main);
            font-weight: 700;
            padding: 10px 20px;
            border-radius: 15px;
            background: var(--bg-color);
            box-shadow: 6px 6px 12px var(--shadow-dark), -6px -6px 12px var(--shadow-light);
            transition: 0.3s;
        }
        .btn-back:hover { color: var(--accent-pink); transform: scale(0.98); }

        /* প্রোফাইল লেআউট */
        .profile-wrapper {
            display: flex;
            gap: 40px;
            align-items: flex-start;
        }

        /* বাম পাশ - ছবি ও সোশ্যাল */
        .profile-left {
            flex: 1;
            text-align: center;
        }

        .img-inset-frame {
            width: 220px;
            height: 220px;
            margin: 0 auto 30px;
            padding: 15px;
            border-radius: 50%;
            box-shadow: inset 10px 10px 20px var(--shadow-dark), inset -10px -10px 20px var(--shadow-light);
        }

        .img-inset-frame img {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            object-fit: cover;
            box-shadow: 5px 5px 15px rgba(0,0,0,0.1);
        }

        .social-box {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 20px;
        }

        .social-btn {
            width: 50px;
            height: 50px;
            line-height: 50px;
            border-radius: 50%;
            background: var(--bg-color);
            color: var(--text-main);
            font-size: 20px;
            box-shadow: 6px 6px 12px var(--shadow-dark), -6px -6px 12px var(--shadow-light);
            transition: 0.3s;
            text-decoration: none;
        }
        .social-btn:hover { color: var(--accent-pink); box-shadow: inset 3px 3px 6px var(--shadow-dark); }

        /* ডান পাশ - তথ্য */
        .profile-right {
            flex: 1.5;
        }

        .name-title {
            font-size: 32px;
            font-weight: 800;
            margin-bottom: 5px;
            color: var(--text-main);
        }

        .role-badge {
            display: inline-block;
            padding: 5px 20px;
            background: var(--bg-color);
            color: var(--accent-pink);
            border-radius: 12px;
            font-weight: 800;
            font-size: 14px;
            box-shadow: inset 4px 4px 8px var(--shadow-dark), inset -4px -4px 8px var(--shadow-light);
            margin-bottom: 30px;
        }

        /* ৩ডি তথ্য বক্স */
        .info-card {
            background: var(--bg-color);
            padding: 25px;
            border-radius: 25px;
            box-shadow: 10px 10px 20px var(--shadow-dark), -10px -10px 20px var(--shadow-light);
            margin-bottom: 30px;
        }

        .info-card h3 {
            font-size: 18px;
            margin-bottom: 15px;
            border-bottom: 2px solid var(--accent-pink);
            display: inline-block;
            padding-bottom: 5px;
        }

        .bio-text {
            font-size: 15px;
            line-height: 1.7;
            color: #666;
            text-align: justify;
        }

        /* জয়েনিং ডাটা ইনসেট লুক */
        .joining-info {
            padding: 20px;
            border-radius: 20px;
            box-shadow: inset 6px 6px 12px var(--shadow-dark), inset -6px -6px 12px var(--shadow-light);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .joining-label { font-weight: 700; font-size: 14px; color: var(--text-main); }
        .joining-value { font-weight: 800; color: var(--accent-pink); font-size: 15px; }

        /* মোবাইল রেসপন্সিভ */
        @media (max-width: 768px) {
            .profile-wrapper { flex-direction: column; text-align: center; }
            .img-inset-frame { width: 180px; height: 180px; }
            .main-container { padding: 30px 20px; border-radius: 35px; }
            .profile-right { text-align: center; }
            .joining-info { flex-direction: column; gap: 10px; }
        }
    </style>
</head>
<body>

    <div class="main-container">
        <!-- ব্যাক বাটন -->
        <a href="index.php" class="btn-back"><i class="fas fa-arrow-left"></i> হোমে ফিরে যান</a>

        <div class="profile-wrapper">
            <!-- বাম পাশ: ছবি ও সোশ্যাল মিডিয়া -->
            <div class="profile-left">
                <div class="img-inset-frame">
                    <?php if($row['image']): ?>
                        <img src="admin/uploads/<?php echo $row['image']; ?>" alt="Profile">
                    <?php else: ?>
                        <div style="width:100%; height:100%; display:flex; align-items:center; justify-content:center; font-size:4rem; color:var(--shadow-dark)">
                            <i class="fas fa-user"></i>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="social-box">
                    <?php if(!empty($row['facebook'])): ?>
                        <a href="<?php echo htmlspecialchars($row['facebook']); ?>" target="_blank" class="social-btn"><i class="fab fa-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($row['linkedin'])): ?>
                        <a href="<?php echo htmlspecialchars($row['linkedin']); ?>" target="_blank" class="social-btn"><i class="fab fa-whatsapp"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($row['github'])): ?>
                        <a href="<?php echo htmlspecialchars($row['github']); ?>" target="_blank" class="social-btn"><i class="fab fa-github"></i></a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- ডান পাশ: বায়ো ও জয়েনিং তথ্য -->
            <div class="profile-right">
                <h1 class="name-title"><?php echo htmlspecialchars($row['name']); ?></h1>
                <span class="role-badge"><?php echo htmlspecialchars($row['role']); ?></span>

                <div class="info-card">
                    <h3>আমার সম্পর্কে</h3>
                    <p class="bio-text">
                        <?php echo !empty($row['bio']) ? nl2br(htmlspecialchars($row['bio'])) : "দুঃখিত, কোনো বিবরণ পাওয়া যায়নি। তবে আমি আমাদের টিমের একজন একনিষ্ঠ সদস্য হিসেবে কাজ করছি।"; ?>
                    </p>
                </div>

                <div class="joining-info">
                    <div>
                        <p class="joining-label"><i class="fas fa-calendar-check"></i> জয়েনিং তারিখ</p>
                        <p class="joining-value"><?php echo !empty($row['joining_date']) ? date("d M, Y", strtotime($row['joining_date'])) : "উল্লেখ নেই"; ?></p>
                    </div>
                    <div style="border-left: 2px solid var(--shadow-dark); height: 40px; margin: 0 15px;" class="hide-mobile"></div>
                    <div>
                        <p class="joining-label"><i class="fas fa-history"></i> অভিজ্ঞতার সময়</p>
                        <p class="joining-value"><?php echo $duration; ?></p>
                    </div>
                </div>
            </div>
        </div>

    </div>

</body>
</html>