<?php
session_start();
// ডেটাবেস কানেকশন
require 'admin/db_config.php';

// ডাটাবেস থেকে ওয়েবসাইট সেটিংস ফেচ করা
$site_res = $conn->query("SELECT * FROM site_settings WHERE id=1");
$site = $site_res->fetch_assoc();

// ভাষা নির্ধারণ
if (isset($_GET['lang'])) {
    $_SESSION['lang'] = $_GET['lang'];
}
$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'bn';

// অনুবাদ ডিকশনারি (Fixing Undefined Key errors)
$words = [
    'bn' => [
        'home' => 'মূলপাতা', 'services' => 'সার্ভিস', 'demos' => 'রেডি ডেমো', 'work' => 'সাম্প্রতিক কাজ',
        'team' => 'আমাদের টিম', 'contact' => 'যোগাযোগ', 'order_btn' => 'অর্ডার করুন',
        'tagline' => 'PREMIUM WEBSITE & APP SOLUTIONS',
        'our_services' => 'আমাদের সার্ভিসসমূহ', 'ready_demos' => 'Ready Project Demos', 
        'recent_work' => 'সাম্প্রতিক কাজ', 'our_team' => 'দক্ষ টিম মেম্বারস', 
        'live_preview' => 'লাইভ প্রিভিউ', 'visit_site' => 'ভিজিট সাইট', 
        'follow_us' => 'আমাদের সোশ্যাল মিডিয়া',
        'address' => 'Gazipur Sadar, Gazipur 1702, Dhaka, Bangladesh',
        's1_t' => 'প্রফেশনাল ওয়েবসাইট ডেভেলপমেন্ট', 's1_p' => 'আপনার ব্যবসার জন্য আধুনিক ও ৩ডি ইউআই ওয়েবসাইট তৈরি করুন।',
        's2_t' => 'প্রিমিয়াম ই-কমার্স সল্যুশন', 's2_p' => 'নিরাপদ পেমেন্ট গেটওয়েসহ আপনার প্রফেশনাল অনলাইন শপ।'
    ],
    'en' => [
        'home' => 'HOME', 'services' => 'SERVICES', 'demos' => 'DEMOS', 'work' => 'WORKS',
        'team' => 'OUR TEAM', 'contact' => 'CONTACT', 'order_btn' => 'ORDER NOW',
        'tagline' => 'PREMIUM WEBSITE & APP SOLUTIONS',
        'our_services' => 'Our Services', 'ready_demos' => 'Ready Project Demos', 
        'recent_work' => 'Recent Works', 'our_team' => 'Expert Team Members', 
        'live_preview' => 'Live Preview', 'visit_site' => 'Visit Site', 
        'follow_us' => 'Follow Us',
        'address' => 'Gazipur Sadar, Gazipur 1702, Dhaka, Bangladesh',
        's1_t' => 'Professional Web Development', 's1_p' => 'Create a modern website with 3D Neumorphic UI for your business.',
        's2_t' => 'Premium E-commerce Solution', 's2_p' => 'Your professional online shop with secure payment gateways.'
    ]
];
$t = $words[$lang]; 

// লাইভ চ্যাট লিঙ্ক
$whatsapp_link = !empty($site['whatsapp_link']) ? $site['whatsapp_link'] : "https://wa.me/yournumber";
$messenger_link = !empty($site['facebook_link']) ? str_replace("facebook.com", "m.me", $site['facebook_link']) : "#";
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/jpeg" href="https://cdn3d.iconscout.com/3d/premium/thumb/html-3d-icon-png-download-12760849.png">
    <title><?php echo htmlspecialchars($site['logo_text'] . $site['logo_span']); ?> - IT Solution</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;800&family=Montserrat:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

    <style>
        :root {
            --bg-color: #e3d9c6; 
            --shadow-dark: #b8af9d;
            --shadow-light: #ffffff;
            --text-main: #5d5345;
            --accent: #f39c12;
        }

        [data-theme="dark"] {
            --bg-color: #1a1a1a;
            --shadow-dark: #000000;
            --shadow-light: #2c2c2c;
            --text-main: #d1d1d1;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; scroll-behavior: smooth; }
        body { background-color: var(--bg-color); color: var(--text-main); padding: 10px; overflow-x: hidden; }

        .main-container { width: 100%; max-width: 1400px; margin: auto; background: var(--bg-color); border-radius: 50px; padding: 25px; box-shadow: 20px 20px 40px var(--shadow-dark), -10px -10px 30px var(--shadow-light); }

        /* Header & Logo */
        header { display: flex; align-items: center; justify-content: space-between; margin-bottom: 40px; padding: 15px 25px; flex-wrap: wrap; gap: 15px; position: sticky; top: 0; background: var(--bg-color); z-index: 1000; border-radius: 300px; box-shadow: 4px 4px 10px rgba(0,0,0,0.05); }
        .logo-container { display: flex; flex-direction: column; text-decoration: none; }
        .logo-text { font-family: 'Montserrat', sans-serif; font-size: 26px; font-weight: 900; text-transform: uppercase; line-height: 1; background: linear-gradient(90deg, #3d3ef5, #ff00ff, #00ffff, #00ff00, #ffff00, #ff0000); background-size: 200% auto; -webkit-background-clip: text; -webkit-text-fill-color: transparent; animation: move-bg 3s linear infinite; filter: drop-shadow(0 0 5px rgba(255, 255, 255, 0.8)); }
        .logo-tagline { font-size: 9px; font-weight: 700; color: var(--text-main); text-transform: uppercase; letter-spacing: 0.5px; margin-top: 5px; opacity: 0.8; }
        @keyframes move-bg { to { background-position: 200% center; } }

        /* Nav Buttons Uniform */
        nav ul { list-style: none; display: flex; gap: 15px; }
        nav ul li a { 
            text-decoration: none; color: var(--text-main); font-weight: 700; font-size: 11px; 
            text-transform: uppercase; width: 110px; height: 38px; display: flex; align-items: center; justify-content: center;
            border-radius: 50px; box-shadow: 4px 4px 8px var(--shadow-dark), -4px -4px 8px var(--shadow-light); transition: 0.3s;
        }
        nav ul li a:hover { box-shadow: inset 3px 3px 6px var(--shadow-dark), inset -3px -3px 6px var(--shadow-light); }

        .header-btn { background: var(--bg-color); color: var(--accent); padding: 10px 20px; border-radius: 50px; font-weight: 800; text-decoration: none; box-shadow: 4px 4px 8px var(--shadow-dark), -4px -4px 8px var(--shadow-light); font-size: 10px; text-transform: uppercase; display: flex; align-items: center; gap: 8px; border: none; cursor: pointer; }

        /* Banner Slider (Accent Style) */
        .hero-section { width: 100%; height: 480px; border-radius: 50px; padding: 15px; margin-bottom: 60px; box-shadow: inset 12px 12px 24px var(--shadow-dark), inset -12px -12px 24px var(--shadow-light); overflow: hidden; position: relative; }
        .hero-slide { display: flex; align-items: center; justify-content: space-between; height: 100%; padding: 40px; gap: 30px; }
        .hero-text { flex: 1.2; }
        .hero-title { font-size: clamp(24px, 5vw, 45px); font-weight: 900; color: var(--accent); text-transform: uppercase; text-shadow: 2px 2px 4px var(--shadow-dark), -1px -1px 2px var(--shadow-light); margin-bottom: 20px; line-height: 1.1; }
        
        .hero-img-box { flex: 0.8; height: 100%; display: flex; align-items: center; justify-content: center; border-radius: 40px; box-shadow: 8px 8px 16px var(--shadow-dark), -8px -8px 16px var(--shadow-light); background: var(--bg-color); overflow: hidden; }
        .hero-img-box img { width: 100%; height: 100%; object-fit: cover; border-radius: 30px; }

        /* Cards & Components */
        .neu-card { background: var(--bg-color); border-radius: 35px; padding: 25px; text-align: center; box-shadow: 10px 10px 20px var(--shadow-dark), -10px -10px 20px var(--shadow-light); height: 100%; display: flex; flex-direction: column; justify-content: space-between; transition: 0.3s; }
        .neu-card:hover { transform: translateY(-5px); }
        
        .icon-inset, .img-inset, .team-profile-box { box-shadow: inset 6px 6px 12px var(--shadow-dark), inset -6px -6px 12px var(--shadow-light); background: var(--bg-color); margin-bottom: 20px; }
        .icon-inset { font-size: 30px; color: var(--accent); width: 70px; height: 70px; line-height: 70px; margin: 0 auto 15px; border-radius: 50%; }
        .img-inset { width: 100%; height: 180px; border-radius: 20px; padding: 10px; overflow: hidden; }
        .img-inset img { width: 100%; height: 100%; object-fit: cover; border-radius: 15px; }

        /* Team Section Fix */
        .team-profile-box { width: 120px; height: 120px; margin: 0 auto 15px; padding: 8px; border-radius: 50%; overflow: hidden; cursor: pointer; transition: 0.3s; }
        .team-profile-box:hover { box-shadow: 4px 4px 10px var(--shadow-dark); transform: scale(1.05); }
        .team-profile-box img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }

        /* Sections */
        .section-title { font-size: 26px; text-align: center; margin-bottom: 50px; font-weight: 900; text-transform: uppercase; color: var(--text-main); }
        .grid-container { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 80px; }
        .neu-btn { background: var(--bg-color); color: var(--accent); padding: 12px 25px; border-radius: 50px; font-weight: 800; text-decoration: none; box-shadow: 5px 5px 10px var(--shadow-dark), -5px -5px 10px var(--shadow-light); font-size: 11px; text-transform: uppercase; display: inline-block; cursor: pointer; border: none; }

        /* Floating Chat */
        .floating-chat { position: fixed; bottom: 30px; right: 30px; display: flex; flex-direction: column; gap: 15px; z-index: 9999; }
        .chat-btn { width: 55px; height: 55px; border-radius: 50%; background: var(--bg-color); display: flex; align-items: center; justify-content: center; font-size: 24px; box-shadow: 6px 6px 12px var(--shadow-dark), -6px -6px 12px var(--shadow-light); text-decoration: none; transition: 0.3s; }
        .chat-btn.whatsapp { color: #25D366; }
        .chat-btn.messenger { color: #0084FF; }
        .chat-btn:hover { transform: scale(1.1); box-shadow: inset 3px 3px 6px var(--shadow-dark); }

        /* Footer */
        .footer-address-box { display: inline-block; padding: 15px 35px; border-radius: 50px; margin-bottom: 25px; box-shadow: inset 4px 4px 8px var(--shadow-dark), inset -4px -4px 8px var(--shadow-light); color: var(--text-main); font-size: 12px; font-weight: 600; }
        .footer-social-icon { width: 45px; height: 45px; display: inline-flex; align-items: center; justify-content: center; border-radius: 50%; color: var(--text-main); font-size: 20px; text-decoration: none; box-shadow: 5px 5px 10px var(--shadow-dark), -5px -5px 10px var(--shadow-light); margin: 0 10px; }

        @media (max-width: 992px) { .hero-img-box, nav, .header-order-btn { display: none; } header { justify-content: center; } .hero-slide { text-align: center; } }
    </style>
</head>
<body>

<div class="main-container">
    <!-- Header -->
    <header>
        <a href="index.php" class="logo-container">
            <span class="logo-text"><?php echo htmlspecialchars($site['logo_text'] . $site['logo_span']); ?></span>
            <span class="logo-tagline"><?php echo $t['tagline']; ?></span>
        </a>
        <nav>
            <ul>
                <li><a href="#home"><?php echo $t['home']; ?></a></li>
                <li><a href="#demos"><?php echo $t['demos']; ?></a></li>
                <li><a href="#work"><?php echo $t['work']; ?></a></li>
                <li><a href="#team"><?php echo $t['team']; ?></a></li>
            </ul>
        </nav>
        <div style="display: flex; align-items: center; gap: 12px;">
            <a href="order.php" class="header-btn header-order-btn"><i class="fas fa-shopping-cart"></i> <?php echo $t['order_btn']; ?></a>
            <button id="theme-toggle" class="header-btn" style="width:38px; height:38px; justify-content:center;"><i class="fas fa-moon"></i></button>
            <div style="padding: 5px 12px; border-radius: 20px; box-shadow: inset 3px 3px 6px var(--shadow-dark), inset -3px -3px 6px var(--shadow-light); font-size: 10px;">
                <a href="?lang=en" style="text-decoration:none; color:inherit;"><?php echo $lang=='en' ? '<span style="color:var(--accent)">EN</span>' : 'EN'; ?></a> / 
                <a href="?lang=bn" style="text-decoration:none; color:inherit;"><?php echo $lang=='bn' ? '<span style="color:var(--accent)">বাং</span>' : 'বাং'; ?></a>
            </div>
        </div>
    </header>

    <!-- Floating Chat -->
    <div class="floating-chat">
        <a href="<?php echo $whatsapp_link; ?>" class="chat-btn whatsapp" target="_blank"><i class="fab fa-whatsapp"></i></a>
        <a href="<?php echo $messenger_link; ?>" class="chat-btn messenger" target="_blank"><i class="fab fa-facebook-messenger"></i></a>
    </div>

    <!-- Hero Slider -->
    <section id="home" class="hero-section">
        <div class="swiper myHeroSlider">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="hero-slide">
                        <div class="hero-text">
                            <h1 class="hero-title"><?php echo $t['s1_t']; ?></h1>
                            <p style="margin-bottom:25px; font-weight:600; opacity:0.8;"><?php echo $t['s1_p']; ?></p>
                            <a href="order.php" class="neu-btn"><i class="fas fa-rocket"></i> <?php echo $t['order_btn']; ?></a>
                        </div>
                        <div class="hero-img-box"><img src="https://images.unsplash.com/photo-1498050108023-c5249f4df085?auto=format&fit=crop&w=1200&q=80"></div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-slide">
                        <div class="hero-text">
                            <h1 class="hero-title"><?php echo $t['s2_t']; ?></h1>
                            <p style="margin-bottom:25px; font-weight:600; opacity:0.8;"><?php echo $t['s2_p']; ?></p>
                            <a href="order.php" class="neu-btn"><i class="fas fa-shopping-bag"></i> <?php echo $t['order_btn']; ?></a>
                        </div>
                        <div class="hero-img-box"><img src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?auto=format&fit=crop&w=1200&q=80"></div>
                    </div>
                </div>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services">
        <h2 class="section-title"><?php echo $t['our_services']; ?></h2>
        <div class="grid-container">
            <?php
            $res_s = $conn->query("SELECT * FROM services WHERE status = 1 ORDER BY id DESC");
            while($row = $res_s->fetch_assoc()):
                $st = ($lang=='en' && !empty($row['title_en'])) ? $row['title_en'] : $row['title'];
                $sd = ($lang=='en' && !empty($row['description_en'])) ? $row['description_en'] : $row['description'];
            ?>
            <div class="neu-card">
                <div class="icon-inset"><i class="fas <?php echo htmlspecialchars($row['icon'] ?: 'fa-code'); ?>"></i></div>
                <h3 style="font-weight: 800; font-size: 18px;"><?php echo htmlspecialchars($st); ?></h3>
                <p style="font-size:13px; opacity:0.7; margin-top: 10px;"><?php echo htmlspecialchars($sd); ?></p>
            </div>
            <?php endwhile; ?>
        </div>
    </section>

    <!-- Ready Demos -->
    <section id="demos">
        <h2 class="section-title"><?php echo $t['ready_demos']; ?></h2>
        <div class="grid-container">
            <?php
            $res_d = $conn->query("SELECT * FROM demos WHERE status = 1 ORDER BY id DESC");
            while($row_d = $res_d->fetch_assoc()):
            ?>
            <div class="neu-card">
                <div class="img-inset"><img src="admin/uploads/<?php echo htmlspecialchars($row_d['image']); ?>" alt="Demo"></div>
                <h3 style="margin-bottom:15px; font-weight: 800;"><?php echo htmlspecialchars(($lang=='en' && !empty($row_d['name_en'])) ? $row_d['name_en'] : $row_d['name']); ?></h3>
                <a href="<?php echo htmlspecialchars($row_d['url']); ?>" target="_blank" class="neu-btn"><?php echo $t['live_preview']; ?> <i class="fas fa-eye"></i></a>
            </div>
            <?php endwhile; ?>
        </div>
    </section>

    <!-- Recent Works Slider -->
    <section id="work" style="margin-bottom: 80px;">
        <h2 class="section-title"><?php echo $t['recent_work']; ?></h2>
        <div class="swiper myWorkSlider" style="padding: 20px 0;">
            <div class="swiper-wrapper">
                <?php
                $res_w = $conn->query("SELECT * FROM recent_works WHERE status = 1 ORDER BY id DESC");
                while($row_w = $res_w->fetch_assoc()):
                ?>
                <div class="swiper-slide" style="padding:15px;">
                    <div class="neu-card">
                        <div class="img-inset"><img src="admin/uploads/<?php echo htmlspecialchars($row_w['image']); ?>" alt="Work"></div>
                        <h3 style="margin-bottom:15px; font-weight: 800;"><?php echo htmlspecialchars($row_w['title']); ?></h3>
                        <a href="<?php echo htmlspecialchars($row_w['link']); ?>" target="_blank" class="neu-btn"><?php echo $t['visit_site']; ?> <i class="fas fa-link"></i></a>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <!-- Team Slider (FIXED) -->
    <section id="team" style="margin-bottom: 80px;">
        <h2 class="section-title"><?php echo $t['our_team']; ?></h2>
        <div class="swiper myTeamSlider" style="padding: 20px 10px;">
            <div class="swiper-wrapper">
                <?php
                $res_t = $conn->query("SELECT * FROM team WHERE status = 1 ORDER BY id ASC");
                while($row_t = $res_t->fetch_assoc()):
                    $id = $row_t['id'];
                ?>
                <div class="swiper-slide" style="padding:15px;">
                    <div class="neu-card" style="border-radius: 40px;">
                        <a href="profile.php?id=<?php echo $id; ?>">
                            <div class="team-profile-box"><img src="admin/uploads/<?php echo htmlspecialchars($row_t['image']); ?>" alt="Team Member"></div>
                        </a>
                        <h3 style="font-weight: 800; font-size: 16px; margin-bottom: 5px;"><?php echo htmlspecialchars($row_t['name']); ?></h3>
                        <p style="color:var(--accent); font-size:11px; font-weight:800; text-transform: uppercase;"><?php echo htmlspecialchars(($lang=='en' && !empty($row_t['role_en'])) ? $row_t['role_en'] : $row_t['role']); ?></p>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <!-- Footer -->
    <footer style="text-align: center;">
        <div class="footer-address-box">
            <i class="fas fa-map-marker-alt" style="margin-right: 8px; color: var(--accent);"></i>
            <?php echo $t['address']; ?>
        </div>
        <div style="display: flex; justify-content: center; margin-bottom: 30px;">
            <?php if(!empty($site['facebook_link'])): ?><a href="<?php echo $site['facebook_link']; ?>" target="_blank" class="footer-social-icon"><i class="fab fa-facebook-f"></i></a><?php endif; ?>
            <?php if(!empty($site['whatsapp_link'])): ?><a href="<?php echo $site['whatsapp_link']; ?>" target="_blank" class="footer-social-icon"><i class="fab fa-whatsapp"></i></a><?php endif; ?>
            <?php if(!empty($site['linkedin_link'])): ?><a href="<?php echo $site['linkedin_link']; ?>" target="_blank" class="footer-social-icon"><i class="fab fa-linkedin-in"></i></a><?php endif; ?>
        </div>
        <p style="font-size:12px; opacity:0.6; font-weight: 700;">&copy; 2025 <?php echo htmlspecialchars($site['logo_text']); ?>. <?php echo ($lang == 'bn') ? htmlspecialchars($site['footer_text_bn']) : htmlspecialchars($site['footer_text_en']); ?></p>
    </footer>
</div>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
    // Theme Logic
    const toggleBtn = document.getElementById('theme-toggle');
    const savedTheme = localStorage.getItem('theme') || 'light';
    document.documentElement.setAttribute('data-theme', savedTheme);
    toggleBtn.onclick = () => {
        const current = document.documentElement.getAttribute('data-theme');
        const next = current === 'dark' ? 'light' : 'dark';
        document.documentElement.setAttribute('data-theme', next);
        localStorage.setItem('theme', next);
    };

    // Hero Slider
    new Swiper(".myHeroSlider", { loop: true, speed: 1000, autoplay: { delay: 5000 }, pagination: { el: ".swiper-pagination", clickable: true } });
    
    // Recent Work Slider
    new Swiper(".myWorkSlider", { slidesPerView: 1, spaceBetween: 20, loop: true, autoplay: { delay: 3500 }, pagination: { el: ".swiper-pagination", clickable: true }, breakpoints: { 768: { slidesPerView: 2 }, 1024: { slidesPerView: 3 } } });
    
    // Team Slider (Fixed dimensions)
    new Swiper(".myTeamSlider", { 
        slidesPerView: 1, spaceBetween: 25, loop: true, 
        autoplay: { delay: 3000, pauseOnMouseEnter: true }, 
        pagination: { el: ".swiper-pagination", clickable: true },
        breakpoints: { 580: { slidesPerView: 2 }, 1024: { slidesPerView: 4 } } 
    });
</script>
</body>
</html>