<?php
// সেশন চেক এবং সিকিউরিটি
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ইউআরএল থেকে ভাষা পরিবর্তন লজিক (Secure handling)
if (isset($_GET['lang'])) {
    $allowed_langs = ['bn', 'en'];
    $new_lang = $_GET['lang'];
    if (in_array($new_lang, $allowed_langs)) {
        $_SESSION['admin_lang'] = $new_lang;
    }
    
    // বর্তমান পেজ এর ইউআরএল বের করা (Query string ছাড়া)
    $current_url = explode('?', $_SERVER["REQUEST_URI"])[0];
    echo "<script>window.location.href='$current_url';</script>";
    exit();
}

// বর্তমান ভাষা নির্ধারণ (ডিফল্ট বাংলা)
$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

// গ্লোবাল অনুবাদ ডাটা
$global_words = [
    'bn' => [
        'admin_panel' => 'অ্যাডমিন প্যানেল',
        'welcome' => 'স্বাগতম',
        'logout' => 'লগআউট',
        'logout_msg' => 'লগআউট করতে চান?',
        'profile' => 'প্রোফাইল'
    ],
    'en' => [
        'admin_panel' => 'Admin Panel',
        'welcome' => 'Welcome',
        'logout' => 'Logout',
        'logout_msg' => 'Are you sure you want to logout?',
        'profile' => 'Profile'
    ]
];
$gh = $global_words[$lang];
?>

<!-- FontAwesome & Google Fonts -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
    :root {
        --header-bg: #ffffff;
        --text-main: #1e293b;
        --text-muted: #64748b;
        --primary: #3498db;
        --danger: #e74c3c;
    }

    .top-header {
        background: var(--header-bg);
        height: 70px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 0 25px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        position: sticky;
        top: 0;
        z-index: 1000;
        font-family: 'Inter', sans-serif;
    }

    .header-left { display: flex; align-items: center; gap: 15px; }
    .header-right { display: flex; align-items: center; gap: 20px; }

    /* মেনু বাটন (Hamburger) - মোবাইলে দৃশ্যমান */
    .menu-btn {
        font-size: 22px;
        color: var(--text-main);
        cursor: pointer;
        padding: 5px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: 0.2s;
    }
    .menu-btn:hover { color: var(--primary); }

    /* ল্যাঙ্গুয়েজ সুইচ ডিজাইন */
    .lang-toggle {
        display: flex;
        background: #f1f5f9;
        padding: 3px;
        border-radius: 10px;
        border: 1px solid #e2e8f0;
    }
    .lang-toggle a {
        padding: 6px 14px;
        border-radius: 8px;
        text-decoration: none;
        font-size: 12px;
        font-weight: 700;
        color: var(--text-muted);
        transition: 0.3s;
    }
    .lang-toggle a.active {
        background: var(--primary);
        color: #ffffff;
        box-shadow: 0 2px 6px rgba(52, 152, 219, 0.3);
    }

    /* প্রোফাইল সেকশন */
    .user-profile { 
        display: flex; 
        align-items: center; 
        gap: 10px; 
        padding-left: 15px;
        border-left: 1px solid #e2e8f0;
    }
    .user-profile img { 
        width: 38px; height: 38px; 
        border-radius: 50%; 
        object-fit: cover;
        border: 2px solid #f1f5f9;
    }
    .user-info { line-height: 1.2; text-align: right; }
    .user-info .name { display: block; font-size: 14px; font-weight: 700; color: var(--text-main); }
    .user-info .role { display: block; font-size: 11px; color: var(--text-muted); text-transform: uppercase; }

    /* লগআউট আইকন */
    .logout-btn {
        color: var(--danger);
        font-size: 20px;
        transition: 0.3s;
        display: flex;
        align-items: center;
    }
    .logout-btn:hover { transform: scale(1.1); }

    /* মোবাইল রেসপনসিভনেস */
    @media (max-width: 991px) {
        .user-info { display: none; } /* মোবাইলে নাম লুকানো থাকবে */
        .top-header { padding: 0 15px; }
        .header-left h3 { font-size: 16px; }
    }

    /* ডেক্সটপে মেনু বাটন লুকানো (যদি ডেক্সটপে সাইডবার ফিক্সড থাকে) */
    @media (min-width: 992px) {
        .menu-btn { display: none; } 
    }
</style>

<header class="top-header">
    <div class="header-left">
        <!-- সাইডবার টগল বাটন (মোবাইলের জন্য) -->
        <div class="menu-btn" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </div>
        <h3 style="margin:0; font-weight: 600; color: #334155;"><?php echo $gh['admin_panel']; ?></h3>
    </div>

    <div class="header-right">
        <!-- ল্যাঙ্গুয়েজ সুইচ -->
        <div class="lang-toggle">
            <a href="?lang=bn" class="<?php echo $lang == 'bn' ? 'active' : ''; ?>">বাংলা</a>
            <a href="?lang=en" class="<?php echo $lang == 'en' ? 'active' : ''; ?>">EN</a>
        </div>

        <!-- ইউজার প্রোফাইল -->
        <div class="user-profile">
            <div class="user-info">
                <span class="name">Admin Name</span>
                <span class="role"><?php echo $gh['welcome']; ?></span>
            </div>
            <img src="https://ui-avatars.com/api/?name=Admin&background=3498db&color=fff&bold=true" alt="Avatar">
        </div>

        <!-- লগআউট বাটন -->
        <a href="logout.php" class="logout-btn" title="<?php echo $gh['logout']; ?>" 
           onclick="return confirm('<?php echo htmlspecialchars($gh['logout_msg'], ENT_QUOTES); ?>')">
            <i class="fas fa-sign-out-alt"></i>
        </a>
    </div>
</header>

<script>
    // সাইডবার টগল ফাংশন (sidebar.php এর সাথে কানেক্টেড)
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');
        if(sidebar) sidebar.classList.toggle('active');
        if(overlay) overlay.classList.toggle('show');
    }
</script>