<?php
session_start();
require 'db_config.php';

// ডাটা আপডেট লজিক
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $logo_text = $_POST['logo_text'];
    $logo_span = $_POST['logo_span'];
    $footer_bn = $_POST['footer_text_bn'];
    $footer_en = $_POST['footer_text_en'];
    $fb = $_POST['facebook_link'];
    $wa = $_POST['whatsapp_link'];
    $li = $_POST['linkedin_link'];
    $yt = $_POST['youtube_link'];

    $sql = "UPDATE site_settings SET 
            logo_text=?, logo_span=?, footer_text_bn=?, footer_text_en=?, 
            facebook_link=?, whatsapp_link=?, linkedin_link=?, youtube_link=? 
            WHERE id=1";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssss", $logo_text, $logo_span, $footer_bn, $footer_en, $fb, $wa, $li, $yt);
    
    if ($stmt->execute()) {
        $msg = "Settings Updated Successfully!";
    }
}

// বর্তমান সেটিংস ফেচ করা
$result = $conn->query("SELECT * FROM site_settings WHERE id=1");
$settings = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Website Settings</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="admin_style.css"> <!-- আপনার অ্যাডমিন সিএসএস -->
    <style>
        .main-content { margin-left: 260px; padding: 20px; }
        .form-card { background: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input, textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; }
        button { background: #3498db; color: #fff; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
    </style>
</head>
<body>
    <?php include 'sidebar.php'; ?>
    
    <div class="main-content">
        <h2><i class="fas fa-cog"></i> Website Global Settings</h2>
        
        <?php if(isset($msg)) echo "<p style='color:green;'>$msg</p>"; ?>

        <div class="form-card">
            <form method="POST">
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label>Logo Main Text (e.g., CODEXIO)</label>
                        <input type="text" name="logo_text" value="<?php echo $settings['logo_text']; ?>">
                    </div>
                    <div class="form-group">
                        <label>Logo Span Text (Pink Color - e.g., BD)</label>
                        <input type="text" name="logo_span" value="<?php echo $settings['logo_span']; ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>Footer Text (Bengali)</label>
                    <textarea name="footer_text_bn" rows="2"><?php echo $settings['footer_text_bn']; ?></textarea>
                </div>
                <div class="form-group">
                    <label>Footer Text (English)</label>
                    <textarea name="footer_text_en" rows="2"><?php echo $settings['footer_text_en']; ?></textarea>
                </div>

                <h3>Social Links</h3>
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group"><label>Facebook URL</label><input type="text" name="facebook_link" value="<?php echo $settings['facebook_link']; ?>"></div>
                    <div class="form-group"><label>WhatsApp Link</label><input type="text" name="whatsapp_link" value="<?php echo $settings['whatsapp_link']; ?>"></div>
                    <div class="form-group"><label>LinkedIn URL</label><input type="text" name="linkedin_link" value="<?php echo $settings['linkedin_link']; ?>"></div>
                    <div class="form-group"><label>YouTube URL</label><input type="text" name="youtube_link" value="<?php echo $settings['youtube_link']; ?>"></div>
                </div>

                <button type="submit">Save Settings</button>
            </form>
        </div>
    </div>
</body>
</html>