<?php
session_start();
require_once 'db_config.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("location: login.php");
    exit;
}

// বর্তমান ভাষা নির্ধারণ (top_header.php এর সেশন অনুযায়ী)
$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

// সার্ভিস পেজের জন্য অনুবাদ
$svc_words = [
    'bn' => [
        'page_title' => 'সার্ভিস ম্যানেজমেন্ট',
        'add_new' => '+ নতুন সার্ভিস যোগ করুন',
        'update_info' => 'সার্ভিস তথ্য আপডেট করুন',
        'svc_title' => 'সার্ভিস টাইটেল',
        'svc_desc' => 'বিবরণ',
        'svc_icon' => 'আইকন ক্লাস (যেমন: fa-code)',
        'save' => 'সেভ করুন',
        'update' => 'আপডেট করুন',
        'cancel' => 'ক্যান্সেল',
        'th_icon' => 'আইকন',
        'th_title' => 'টাইটেল',
        'th_desc' => 'বিবরণ',
        'th_status' => 'স্ট্যাটাস',
        'th_action' => 'অ্যাকশন',
        'active' => 'Active',
        'hidden' => 'Hidden',
        'no_data' => 'কোনো সার্ভিস নেই',
        'confirm_delete' => 'আপনি কি নিশ্চিত?',
        'msg_add' => 'নতুন সার্ভিস যুক্ত হয়েছে!',
        'msg_update' => 'সার্ভিস আপডেট হয়েছে!',
        'msg_delete' => 'সার্ভিস ডিলিট হয়েছে!'
    ],
    'en' => [
        'page_title' => 'Service Management',
        'add_new' => '+ Add New Service',
        'update_info' => 'Update Service Information',
        'svc_title' => 'Service Title',
        'svc_desc' => 'Description',
        'svc_icon' => 'Icon Class (e.g., fa-code)',
        'save' => 'Save Now',
        'update' => 'Update Now',
        'cancel' => 'Cancel',
        'th_icon' => 'Icon',
        'th_title' => 'Title',
        'th_desc' => 'Description',
        'th_status' => 'Status',
        'th_action' => 'Action',
        'active' => 'Active',
        'hidden' => 'Hidden',
        'no_data' => 'No services found',
        'confirm_delete' => 'Are you sure?',
        'msg_add' => 'New service added successfully!',
        'msg_update' => 'Service updated successfully!',
        'msg_delete' => 'Service deleted successfully!'
    ]
];
$t = $svc_words[$lang];

// ================= PHP লজিক শুরু ================= //

// ১. সার্ভিস সেভ বা আপডেট
if (isset($_POST['save_service'])) {
    $id = $_POST['svc_id'];
    $title = mysqli_real_escape_string($conn, $_POST['svc_title']);
    $desc = mysqli_real_escape_string($conn, $_POST['svc_desc']);
    $icon = mysqli_real_escape_string($conn, $_POST['svc_icon']);

    if ($id) {
        $sql = "UPDATE services SET title='$title', description='$desc', icon='$icon' WHERE id=$id";
        $msg = $t['msg_update'];
    } else {
        $sql = "INSERT INTO services (title, description, icon, status) VALUES ('$title', '$desc', '$icon', 1)";
        $msg = $t['msg_add'];
    }
    
    if(mysqli_query($conn, $sql)){
        echo "<script>alert('$msg'); window.location.href='services.php';</script>";
    } else {
        echo "<script>window.location.href='services.php';</script>";
    }
}

// ২. স্ট্যাটাস টগল
if (isset($_GET['toggle_status'])) {
    $id = intval($_GET['toggle_status']);
    $check_col = mysqli_query($conn, "SHOW COLUMNS FROM services LIKE 'status'");
    if(mysqli_num_rows($check_col) > 0) {
        mysqli_query($conn, "UPDATE services SET status = 1 - status WHERE id=$id");
    }
    echo "<script>window.location.href='services.php';</script>";
}

// ৩. ডিলিট
if (isset($_GET['delete_service'])) {
    $id = intval($_GET['delete_service']);
    mysqli_query($conn, "DELETE FROM services WHERE id=$id");
    echo "<script>alert('".$t['msg_delete']."'); window.location.href='services.php';</script>";
}

// ৪. এডিট ডাটা ফেচ
$edit_data = null;
if (isset($_GET['edit_service'])) {
    $id = intval($_GET['edit_service']);
    $res = mysqli_query($conn, "SELECT * FROM services WHERE id=$id");
    $edit_data = mysqli_fetch_assoc($res);
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['page_title']; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root { --primary: #2c3e50; --accent: #3498db; --bg: #f4f6f9; }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI', sans-serif; }
        body { background: var(--bg); display:flex; min-height:100vh; }
        
        .main-content { margin-left:250px; width:calc(100% - 250px); transition: 0.3s; min-height: 100vh; }
        .content-body { padding: 30px; }

        /* ব্যাজ ও বাটন */
        .status-badge { padding: 5px 10px; border-radius: 20px; font-size: 0.8rem; color: #fff; font-weight: bold; }
        .status-active { background: #27ae60; }
        .status-inactive { background: #e74c3c; }

        .action-btn { padding: 6px 10px; border-radius: 4px; color: #fff; text-decoration: none; font-size: 0.85rem; margin-right: 5px; display: inline-block; }
        .btn-edit { background: #f39c12; } .btn-hide { background: #34495e; } .btn-show { background: #27ae60; } .btn-delete { background: #c0392b; }

        /* ফর্ম */
        .form-container { background: #fff; padding: 25px; border-radius: 8px; margin-bottom: 30px; border-left: 5px solid var(--accent); box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 600; }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; }
        .submit-btn { background: var(--accent); color: #fff; padding: 10px 25px; border: none; cursor: pointer; border-radius: 4px; font-size: 1rem; }

        /* টেবিল */
        table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        th, td { padding: 15px; border-bottom: 1px solid #eee; text-align: left; vertical-align: middle; }
        th { background: #f8f9fa; color: var(--primary); }

        @media(max-width:768px){ .main-content{margin-left:0; width:100%;} }
    </style>
</head>
<body>

    <!-- সাইডবার ইনক্লুড -->
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        <!-- গ্লোবাল টপ হেডার ইনক্লুড -->
        <?php include 'top_header.php'; ?>

        <div class="content-body">
            <!-- অ্যাড / এডিট ফর্ম -->
            <div class="form-container">
                <h4><?php echo $edit_data ? $t['update_info'] : $t['add_new']; ?></h4>
                <br>
                <form method="POST">
                    <input type="hidden" name="svc_id" value="<?php echo $edit_data['id'] ?? ''; ?>">
                    
                    <div class="form-group">
                        <label><?php echo $t['svc_title']; ?></label>
                        <input type="text" name="svc_title" class="form-control" value="<?php echo $edit_data['title'] ?? ''; ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label><?php echo $t['svc_desc']; ?></label>
                        <textarea name="svc_desc" class="form-control" rows="3" required><?php echo $edit_data['description'] ?? ''; ?></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label><?php echo $t['svc_icon']; ?></label>
                        <input type="text" name="svc_icon" class="form-control" value="<?php echo $edit_data['icon'] ?? ''; ?>" placeholder="fa-code">
                    </div>

                    <button type="submit" name="save_service" class="submit-btn">
                        <?php echo $edit_data ? $t['update'] : $t['save']; ?>
                    </button>
                    
                    <?php if($edit_data): ?>
                        <a href="services.php" style="margin-left:10px; color:red; text-decoration:none;"><?php echo $t['cancel']; ?></a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- সার্ভিস লিস্ট টেবিল -->
            <div style="overflow-x:auto;">
                <table>
                    <thead>
                        <tr>
                            <th><?php echo $t['th_icon']; ?></th>
                            <th><?php echo $t['th_title']; ?></th>
                            <th><?php echo $t['th_desc']; ?></th>
                            <th><?php echo $t['th_status']; ?></th>
                            <th><?php echo $t['th_action']; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $res = mysqli_query($conn, "SELECT * FROM services ORDER BY id DESC");
                        if(mysqli_num_rows($res) > 0) {
                            while($row = mysqli_fetch_assoc($res)){
                                $status = isset($row['status']) ? $row['status'] : 1;
                                $status_text = ($status == 1) ? $t['active'] : $t['hidden'];
                                $status_class = ($status == 1) ? 'status-active' : 'status-inactive';
                        ?>
                            <tr>
                                <td><i class="fas <?php echo htmlspecialchars($row['icon']); ?>" style="font-size:1.5rem; color:#3498db;"></i></td>
                                <td><b><?php echo htmlspecialchars($row['title']); ?></b></td>
                                <td><?php echo mb_substr(htmlspecialchars($row['description']), 0, 60) . '...'; ?></td>
                                <td><span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span></td>
                                <td>
                                    <a href="services.php?edit_service=<?php echo $row['id']; ?>" class="action-btn btn-edit"><i class="fas fa-edit"></i></a>
                                    
                                    <a href="services.php?toggle_status=<?php echo $row['id']; ?>" class="action-btn <?php echo ($status == 1) ? 'btn-hide' : 'btn-show'; ?>">
                                        <?php if($status == 1): ?>
                                            <i class="fas fa-eye-slash"></i>
                                        <?php else: ?>
                                            <i class="fas fa-eye"></i>
                                        <?php endif; ?>
                                    </a>
                                    
                                    <a href="services.php?delete_service=<?php echo $row['id']; ?>" class="action-btn btn-delete" onclick="return confirm('<?php echo $t['confirm_delete']; ?>')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php } } else { ?>
                            <tr><td colspan="5" style="text-align:center; padding:20px;"><?php echo $t['no_data']; ?></td></tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>