<?php
session_start();
require_once 'db_config.php';

// লগইন চেক (dashboard.php এর মতো)
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("location: login.php");
    exit;
}

// বর্তমান ভাষা নির্ধারণ
$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

// ডিলিট লজিক (Prepared Statement - Secure)
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM orders WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        echo "<script>alert('অর্ডারটি ডিলিট করা হয়েছে'); window.location='orders_manage.php';</script>";
    }
    $stmt->close();
}

// অনুবাদ
$t_words = [
    'bn' => [
        'title' => 'অর্ডার ম্যানেজমেন্ট',
        'subtitle' => 'এখান থেকে আপনি আপনার ওয়েবসাইটের সকল কাস্টমার অর্ডার নিয়ন্ত্রণ করতে পারবেন।',
        'table_id' => 'আইডি',
        'table_client' => 'ক্লায়েন্ট তথ্য',
        'table_web' => 'ওয়েবসাইট নাম',
        'table_date' => 'তারিখ',
        'table_pay' => 'পেমেন্ট',
        'table_action' => 'অ্যাকশন'
    ],
    'en' => [
        'title' => 'Order Management',
        'subtitle' => 'From here you can control all the customer orders of your website.',
        'table_id' => 'ID',
        'table_client' => 'Client Info',
        'table_web' => 'Website Name',
        'table_date' => 'Date',
        'table_pay' => 'Payment',
        'table_action' => 'Action'
    ]
];
$tw = $t_words[$lang];
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $tw['title']; ?> - Admin Panel</title>
    
    <!-- FontAwesome & CSS (Dashboard এর মতো) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        :root { --primary: #2c3e50; --bg: #f4f6f9; --accent: #3498db; }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        
        body { background: var(--bg); display:flex; min-height:100vh; }
        
        /* ড্যাশবোর্ড স্ট্রাকচার */
        .main-content { 
            margin-left: 250px; 
            width: calc(100% - 250px); 
            transition: 0.3s; 
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .content-body { padding: 30px; }

        /* ওয়েলকাম ব্যানার */
        .welcome-banner {
            background: linear-gradient(135deg, #1e293b, #334155);
            color: #fff;
            padding: 40px;
            border-radius: 12px;
            margin-bottom: 35px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }

        /* টেবিল কার্ড ডিজাইন */
        .custom-card {
            background: #fff;
            border-radius: 12px;
            border: 1px solid #edf2f7;
            box-shadow: 0 4px 10px rgba(0,0,0,0.03);
            overflow: hidden;
        }
        
        .table thead { background: #f8fafc; }
        .table thead th { color: #64748b; font-size: 13px; text-transform: uppercase; padding: 15px; border-bottom: 2px solid #edf2f7; }
        .table tbody td { padding: 15px; vertical-align: middle; border-bottom: 1px solid #f1f5f9; }

        /* পেমেন্ট ব্যাজ */
        .badge-payment { background: #dcfce7; color: #166534; padding: 5px 12px; border-radius: 50px; font-size: 12px; font-weight: 600; }

        /* রেসপন্সিভ */
        @media(max-width:768px){ 
            .main-content { margin-left:0; width:100%; } 
        }
    </style>
</head>
<body>

    <!-- ১. সাইডবার ইনক্লুড (ড্যাশবোর্ডের মতো) -->
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        
        <!-- ২. টপ হেডার ইনক্লুড -->
        <?php include 'top_header.php'; ?>

        <!-- ৩. মেইন কন্টেন্ট বডি -->
        <div class="content-body">
            
            <!-- ওয়েলকাম ব্যানার -->
            <div class="welcome-banner">
                <h2><?php echo $tw['title']; ?> 👋</h2>
                <p><?php echo $tw['subtitle']; ?></p>
            </div>

            <!-- ডাটা টেবিল -->
            <div class="custom-card">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th><?php echo $tw['table_id']; ?></th>
                                <th><?php echo $tw['table_client']; ?></th>
                                <th><?php echo $tw['table_web']; ?></th>
                                <th><?php echo $tw['table_date']; ?></th>
                                <th><?php echo $tw['table_pay']; ?></th>
                                <th class="text-center"><?php echo $tw['table_action']; ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $res = mysqli_query($conn, "SELECT * FROM orders ORDER BY id DESC");
                            while ($row = mysqli_fetch_assoc($res)) {
                            ?>
                            <tr>
                                <td class="fw-bold">#<?php echo $row['id']; ?></td>
                                <td>
                                    <div class="fw-bold"><?php echo htmlspecialchars($row['client_name']); ?></div>
                                    <small class="text-muted"><?php echo htmlspecialchars($row['mobile_number']); ?></small>
                                </td>
                                <td><span class="text-primary"><?php echo htmlspecialchars($row['website_name']); ?></span></td>
                                <td><?php echo date('d M, Y', strtotime($row['project_start_date'])); ?></td>
                                <td><span class="badge-payment"><?php echo htmlspecialchars($row['payment_method']); ?></span></td>
                                <td class="text-center">
                                    <a href="order_view.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-light border text-primary rounded-pill px-3">
                                        <i class="fas fa-eye me-1"></i> বিস্তারিত
                                    </a>
                                    <a href="orders_manage.php?delete=<?php echo $row['id']; ?>" 
                                       class="btn btn-sm btn-light border text-danger rounded-pill px-3" 
                                       onclick="return confirm('ডিলিট করতে চান?')">
                                        <i class="fas fa-trash me-1"></i> ডিলিট
                                    </a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>