<?php
include('db_config.php'); 
include('top_header.php'); 
include('sidebar.php');   

// সাকসেস মেসেজ দেখানোর জন্য ফ্ল্যাগ
$show_success = false;

// ডাটা সেভ করার সিকিউর লজিক (SQL Injection Protection)
if(isset($_POST['add_database'])){
    $date   = mysqli_real_escape_string($conn, $_POST['rent_date']);
    $serial = mysqli_real_escape_string($conn, $_POST['serial_no']);
    $amount = mysqli_real_escape_string($conn, $_POST['amount']);
    $remark = mysqli_real_escape_string($conn, $_POST['remark']);

    if(!empty($date) && !empty($amount)){
        $sql = "INSERT INTO dukan_vara (rent_date, serial_no, amount, remark) VALUES ('$date', '$serial', '$amount', '$remark')";
        if(mysqli_query($conn, $sql)){
            $show_success = true; 
        }
    }
}
?>

<!-- মডার্ন ফন্ট, আইকন এবং পপআপ লাইব্রেরি -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

<style>
    :root {
        --primary-color: #3b82f6;
        --success-gradient: linear-gradient(135deg, #84cc16 0%, #65a30d 100%);
        --dark-bg: #1e293b;
        --border-color: #000000; /* আপনার রিকুয়্যারমেন্ট অনুযায়ী কালো বর্ডার */
    }

    body { font-family: 'Inter', sans-serif; background-color: #f1f5f9; color: #334155; }

    /* মেইন কন্টেন্ট এরিয়া - সাইডবারের সাথে সামঞ্জস্যপূর্ণ */
    .content-wrapper { 
        margin-left: 260px; 
        padding: 25px; 
        transition: all 0.3s ease;
        min-height: 100vh;
    }

    .page-header {
        background: #fff;
        padding: 15px 25px;
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        margin-bottom: 25px;
        border-left: 6px solid var(--primary-color);
    }

    /* ৩ডি কার্ড ডিজাইন */
    .custom-card {
        background: #fff;
        border-radius: 15px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.08);
        padding: 25px;
        margin-bottom: 30px;
        border: 1px solid #e2e8f0;
    }

    /* রেসপনসিভ ইনপুট গ্রিড */
    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 20px;
        align-items: end;
    }

    .input-group label {
        display: block;
        font-weight: 600;
        font-size: 13px;
        color: #64748b;
        margin-bottom: 8px;
        text-transform: uppercase;
    }

    .form-control-custom {
        width: 100%;
        height: 45px;
        padding: 10px 15px;
        border-radius: 10px;
        border: 1px solid #cbd5e1;
        font-size: 14px;
        transition: 0.3s;
    }

    .form-control-custom:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
        outline: none;
    }

    /* প্রিমিয়াম বাটন */
    .btn-add {
        background: var(--success-gradient);
        color: white;
        height: 45px;
        padding: 0 30px;
        border-radius: 10px;
        border: none;
        font-weight: 700;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        transition: 0.3s;
        box-shadow: 0 4px 15px rgba(132, 204, 22, 0.3);
        width: 100%;
    }

    .btn-add:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(132, 204, 22, 0.4); }

    /* প্রফেশনাল টেবিল উইথ বর্ডার */
    .table-container { 
        border-radius: 12px; 
        overflow: hidden; 
        border: 1px solid var(--border-color); 
    }

    .custom-table { width: 100%; border-collapse: collapse; background: #fff; }
    .custom-table thead { background: var(--dark-bg); color: #fff; }

    .custom-table th, .custom-table td {
        padding: 15px;
        border: 1px solid var(--border-color) !important;
        text-align: center;
        font-size: 14px;
    }

    .custom-table tbody tr:nth-child(even) { background: #f8fafc; }
    .custom-table tbody tr:hover { background: #f1f5f9; }

    .grand-total {
        background: #f1f5f9 !important;
        font-weight: 800;
        color: #000;
    }

    /* মোবাইল রেসপনসিভনেস */
    @media (max-width: 991px) {
        .content-wrapper { margin-left: 0; padding: 15px; }
        .form-grid { grid-template-columns: 1fr; }
        .page-header h3 { font-size: 18px; }
    }

    /* ৩ডি পপআপ কাস্টম স্টাইল */
    .my-3d-popup {
        border-radius: 20px !important;
        box-shadow: 0 20px 60px rgba(0,0,0,0.3) !important;
    }
</style>

<div class="content-wrapper">
    <!-- পেজ টাইটেল -->
    <div class="page-header">
        <h3 style="margin:0;"><i class="fas fa-store-alt" style="color: var(--primary-color);"></i> Dukan Vara Management</h3>
    </div>

    <!-- ডাটা এন্ট্রি ফরম কার্ড -->
    <div class="custom-card">
        <form method="POST" action="">
            <div class="form-grid">
                <div class="input-group">
                    <label>Select Date</label>
                    <input type="date" name="rent_date" class="form-control-custom" required>
                </div>
                <div class="input-group">
                    <label>Serial No</label>
                    <input type="text" name="serial_no" class="form-control-custom" placeholder="e.g. 1421">
                </div>
                <div class="input-group">
                    <label>Amount (TK)</label>
                    <input type="number" name="amount" class="form-control-custom" placeholder="0.00" required>
                </div>
                <div class="input-group" style="flex: 1.5;">
                    <label>Remark</label>
                    <input type="text" name="remark" class="form-control-custom" placeholder="Enter note...">
                </div>
                <div class="input-group">
                    <button type="submit" name="add_database" class="btn-add">
                        <i class="fas fa-plus-circle"></i> ADD DATA
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- ডাটা টেবিল কার্ড -->
    <div class="custom-card" style="padding: 0;">
        <div class="table-container">
            <div style="overflow-x: auto;">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th width="70"># NO</th>
                            <th>DATE</th>
                            <th>SERIAL NO</th>
                            <th>AMOUNT</th>
                            <th>ACCUMULATED TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $query = "SELECT * FROM dukan_vara ORDER BY id ASC";
                        $result = mysqli_query($conn, $query);
                        $count = 1;
                        $running_total = 0;

                        if(mysqli_num_rows($result) > 0){
                            while($row = mysqli_fetch_assoc($result)){
                                $running_total += $row['amount'];
                                ?>
                                <tr>
                                    <td><?php echo str_pad($count++, 2, "0", STR_PAD_LEFT); ?></td>
                                    <td><i class="far fa-calendar-check text-muted"></i> <?php echo date('d M, Y', strtotime($row['rent_date'])); ?></td>
                                    <td><strong><?php echo $row['serial_no']; ?></strong></td>
                                    <td style="color: #16a34a; font-weight: 600;">৳ <?php echo number_format($row['amount'], 2); ?></td>
                                    <td style="color: #2563eb; font-weight: 600;">৳ <?php echo number_format($running_total, 2); ?></td>
                                </tr>
                            <?php } 
                        } else {
                            echo "<tr><td colspan='5' style='padding: 40px;' class='text-muted'>No data records available.</td></tr>";
                        } ?>
                    </tbody>
                    <tfoot>
                        <tr class="grand-total">
                            <td colspan="3" style="text-align: right; padding-right: 30px;">GRAND TOTAL:</td>
                            <td colspan="2" style="font-size: 18px; color: #1e293b;">৳ <?php echo number_format($running_total, 2); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- সাকসেস পপআপ স্ক্রিপ্ট -->
<?php if($show_success): ?>
<script>
    Swal.fire({
        title: 'Success!',
        text: 'Data Saved Successfully to Database',
        icon: 'success',
        confirmButtonText: 'OK',
        confirmButtonColor: '#84cc16',
        showClass: { popup: 'animate__animated animate__zoomIn' },
        hideClass: { popup: 'animate__animated animate__zoomOut' },
        customClass: { popup: 'my-3d-popup' }
    }).then(() => {
        window.location.href = 'dukan_vara_manage.php';
    });
</script>
<?php endif; ?>

<script>
    // মোবাইলে সাইডবার অ্যাডজাস্টমেন্ট
    if (window.innerWidth < 992) {
        const wrapper = document.querySelector('.content-wrapper');
        if(wrapper) wrapper.style.marginLeft = '0';
    }
</script>