<?php
session_start();
require_once 'db_config.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("location: login.php");
    exit;
}

// বর্তমান ভাষা নির্ধারণ (top_header.php এর সেশন অনুযায়ী)
$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

// ড্যাশবোর্ড পেজের জন্য আলাদা অনুবাদ
$dash_words = [
    'bn' => [
        'welcome_msg' => 'স্বাগতম, অ্যাডমিন প্যানেলে! 👋',
        'welcome_sub' => 'এখান থেকে আপনি আপনার ওয়েবসাইটের সকল কন্টেন্ট নিয়ন্ত্রণ করতে পারবেন।',
        'team' => 'টিম মেম্বার',
        'demo' => 'ডেমো প্রোডাক্ট',
        'service' => 'মোট সার্ভিস',
        'work' => 'রিসেন্ট ওয়ার্ক',
        'notice' => 'নোটিশ'
    ],
    'en' => [
        'welcome_msg' => 'Welcome to Admin Panel! 👋',
        'welcome_sub' => 'From here you can control all the contents of your website.',
        'team' => 'Team Members',
        'demo' => 'Demo Products',
        'service' => 'Total Services',
        'work' => 'Recent Works',
        'notice' => 'Notices'
    ]
];
$t = $dash_words[$lang];

// --- ডাটাবেস থেকে কাউন্ট বের করার ফাংশন ---
function getCount($conn, $table) {
    $check = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
    if(mysqli_num_rows($check) > 0) {
        $res = mysqli_query($conn, "SELECT COUNT(*) as total FROM $table");
        return mysqli_fetch_assoc($res)['total'];
    }
    return 0;
}

$total_team = getCount($conn, 'team');
$total_services = getCount($conn, 'services');
$total_demos = getCount($conn, 'demos');
$total_works = getCount($conn, 'recent_works');
$total_notices = getCount($conn, 'notices');
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/jpeg" href="https://cdn3d.iconscout.com/3d/premium/thumb/html-3d-icon-png-download-12760849.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ($lang == 'bn') ? 'ড্যাশবোর্ড - অ্যাডমিন প্যানেল' : 'Dashboard - Admin Panel'; ?></title>
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        :root { --primary: #2c3e50; --bg: #f4f6f9; --accent: #3498db; }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        
        body { background: var(--bg); display:flex; min-height:100vh; }
        
        /* মেইন কন্টেন্ট এরিয়া */
        .main-content { 
            margin-left: 250px; 
            width: calc(100% - 250px); 
            transition: 0.3s; 
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .content-body { padding: 30px; }

        /* ওয়েলকাম ব্যানার */
        .welcome-banner {
            background: linear-gradient(135deg, #1e293b, #334155);
            color: #fff;
            padding: 40px;
            border-radius: 12px;
            margin-bottom: 35px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .welcome-banner h2 { font-size: 24px; margin-bottom: 10px; }
        .welcome-banner p { opacity: 0.8; font-size: 15px; }

        /* স্ট্যাটাস কার্ড গ্রিড */
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 25px;
        }

        /* কার্ড ডিজাইন */
        .stat-card {
            background: #fff;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.03);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: 0.3s;
            position: relative;
            border: 1px solid #edf2f7;
        }
        .stat-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.08); }

        .stat-info h3 { font-size: 2rem; margin-bottom: 5px; color: #1e293b; }
        .stat-info p { color: #64748b; font-weight: 600; font-size: 14px; }
        .stat-icon { font-size: 2.5rem; color: var(--accent); opacity: 0.15; }

        /* লিঙ্কের জন্য ওভারলে */
        .card-link { position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 5; }

        /* রেসপন্সিভ */
        @media(max-width:768px){ 
            .main-content { margin-left:0; width:100%; } 
        }
    </style>
</head>
<body>

    <!-- ১. সাইডবার ইনক্লুড -->
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        
        <!-- ২. গ্লোবাল টপ হেডার ইনক্লুড (যেখানে ল্যাঙ্গুয়েজ সুইচ আছে) -->
        <?php include 'top_header.php'; ?>

        <!-- ৩. মেইন কন্টেন্ট বডি -->
        <div class="content-body">
            
            <!-- ওয়েলকাম সেকশন -->
            <div class="welcome-banner">
                <h2><?php echo $t['welcome_msg']; ?></h2>
                <p><?php echo $t['welcome_sub']; ?></p>
            </div>

            <!-- স্ট্যাটাস কার্ডস -->
            <div class="dashboard-grid">
                
                <!-- টিম মেম্বার -->
                <div class="stat-card">
                    <a href="team_manage.php" class="card-link"></a>
                    <div class="stat-info">
                        <h3><?php echo $total_team; ?></h3>
                        <p><?php echo $t['team']; ?></p>
                    </div>
                    <i class="fas fa-users stat-icon"></i>
                </div>

                <!-- ডেমো প্রোডাক্ট -->
                <div class="stat-card">
                    <a href="demo_manage.php" class="card-link"></a>
                    <div class="stat-info">
                        <h3><?php echo $total_demos; ?></h3>
                        <p><?php echo $t['demo']; ?></p>
                    </div>
                    <i class="fas fa-laptop-code stat-icon"></i>
                </div>

                <!-- সার্ভিস -->
                <div class="stat-card">
                    <a href="services.php" class="card-link"></a>
                    <div class="stat-info">
                        <h3><?php echo $total_services; ?></h3>
                        <p><?php echo $t['service']; ?></p>
                    </div>
                    <i class="fas fa-tools stat-icon"></i>
                </div>

                <!-- রিসেন্ট ওয়ার্ক -->
                <div class="stat-card">
                    <a href="recent_work_manage.php" class="card-link"></a>
                    <div class="stat-info">
                        <h3><?php echo $total_works; ?></h3>
                        <p><?php echo $t['work']; ?></p>
                    </div>
                    <i class="fas fa-briefcase stat-icon"></i>
                </div>

                <!-- নোটিশ -->
                <div class="stat-card">
                    <a href="notice_manage.php" class="card-link"></a>
                    <div class="stat-info">
                        <h3><?php echo $total_notices; ?></h3>
                        <p><?php echo $t['notice']; ?></p>
                    </div>
                    <i class="fas fa-bullhorn stat-icon"></i>
                </div>

            </div>
        </div>

    </main>

    <script>
        // মোবাইলে সাইডবার টগল করার জন্য (যদি প্রয়োজন হয়)
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>